VehicleCombat = { 
    description = "VehicleCombat"
}

function VehicleCombat:new()


	--Handle interrupts
	
	createConstantStatModifier("NullifyCallReinforcements", "Multiplier", "BaseStats.CanCallReinforcements", 0)
	TweakDB:CreateRecord("NullifyCallReinforcementsPackage", "gamedataGameplayLogicPackage_Record")
	TweakDB:SetFlat("NullifyCallReinforcementsPackage.stats", {"NullifyCallReinforcements"})
	
	--Overheat
	addNullifyCallReinforcements("BaseStatusEffect.OverheatLevel4")

	TweakDB:SetFlat("BaseStatusEffect.OverheatLevel4.gameplayTags", {"Debuff", "DoT", "Quickhack", "Overheat", "CommsNoiseJam"})
	
	--Increase range of caller
	addAbility("SpecialActions.CallReinforcements_inline1.AND", "Condition.TargetAbove12m")
	addAbility("SpecialActions.CoverCallReinforcements_inline1.AND", "Condition.TargetAbove12m")

	--Stop everyone getting on phone at once
	
	--Create the status effect
	TweakDB:CloneRecord("BaseStatusEffect.PlayerBeingCalledOn", "BaseStatusEffect.DecreaseSmartWeaponHitProbability")
	TweakDB:SetFlat("BaseStatusEffect.PlayerBeingCalledOn.packages", {})
	TweakDB:SetFlat("BaseStatusEffect.PlayerBeingCalledOn.duration", "BaseStatusEffect.PlayerBeingCalledOnDurationGroup")

	TweakDB:CreateRecord("BaseStatusEffect.PlayerBeingCalledOnDurationGroup", "gamedataStatModifierGroup_Record")
	TweakDB:SetFlat("BaseStatusEffect.PlayerBeingCalledOnDurationGroup.statModsLimit", -1)
	TweakDB:SetFlat("BaseStatusEffect.PlayerBeingCalledOnDurationGroup.statModifiers", {"BaseStatusEffect.PlayerBeingCalledOnDuration"})
	createConstantStatModifier("BaseStatusEffect.PlayerBeingCalledOnDuration", "Additive", "BaseStats.MaxDuration", Call_Reinforcements_Duration)
	
	--Create our condition for V not having that status effect
	TweakDB:CreateRecord("Condition.NotPlayerBeingCalledOn", "gamedataAIStatusEffectCond_Record")
	TweakDB:SetFlat("Condition.NotPlayerBeingCalledOn.statusEffect", "BaseStatusEffect.PlayerBeingCalledOn")
	TweakDB:SetFlat("Condition.NotPlayerBeingCalledOn.target", "AIActionTarget.Player")
	TweakDB:SetFlat("Condition.NotPlayerBeingCalledOn.invert", true)

	--Set V not having the status effect being a condition of calling
	addAbility("SpecialActions.CallReinforcements_inline1.AND", "Condition.NotPlayerBeingCalledOn")
	addAbility("SpecialActions.CoverCallReinforcements_inline1.AND", "Condition.NotPlayerBeingCalledOn")

	--Disable calling for reinforcements when out in the open
	TweakDB:SetFlat("SpecialActions.CallReinforcements.activationCondition", "SpecialActions.CoverCallReinforcements_inline0")
	
	--Set duration of call
	TweakDB:SetFlat("SpecialActions.CallReinforcements_inline7.duration", Call_Reinforcements_Duration)
		
	--Each character record that can call these bad boys
	Character_List = {
	
	--Arroyo
	--"Character.arr_arasaka_ranger1_ranged2_masamune_ma", "Character.arr_arasaka_ranger1_ranged2_shingen_ma", "Character.arr_arasaka_ranger1_ranged2_shingen_wa", "Character.arr_arasaka_security1_ranged1_shingen_ma",
	"Character.arr_sixthstreet_hooligan_ranged1_nova_ma", "Character.arr_sixthstreet_hooligan_ranged1_saratoga_ma", "Character.arr_sixthstreet_hooligan_ranged1_saratoga_wa", "Character.arr_sixthstreet_hooligan_ranged1_nova_ma", "Character.arr_sixthstreet_patrol2_ranged2_ajax_wa", "Character.arr_sixthstreet_prepers3_grenadier2_nova_ma_rare", "Character.arr_sixthstreet_veteran3_ranged2_ajax_ma", "Character.sts_std_arr_01_sixthstreet_hooligan_ranged1_nova_ma", "Character.sts_std_arr_01_sixthstreet_officer_officer_overture_ma", "Character.sts_std_arr_01_sixthstreet_hooligan_ranged1_nova_wa", "Character.sts_std_arr_01_sixthstreet_patrol2_ranged2_ajax_wa",
	
	--Rancho Coronado
	"Character.rcr_sixthstreet_hooligan_ranged1_nova_ma", "Character.rcr_sixthstreet_hooligan_ranged1_saratoga_ma", "Character.rcr_sixthstreet_hooligan_ranged1_nova_wa", "Character.rcr_sixthstreet_hooligan_ranged1_saratoga_wa", "Character.rcr_sixthstreet_officer_officer_overture_ma", "Character.rcr_sixthstreet_patrol2_ranged2_ajax_wa", "Character.rcr_sixthstreet_prepers3_grenadier2_nova_ma_rare", "Character.rcr_sixthstreet_veteran3_ranged2_ajax_ma",
	
	--Little China
	"Character.lch_tyger_claws_biker1_ranged1_nue_ma", "Character.lch_tyger_claws_biker1_ranged1_nue_wa", "Character.lch_tyger_claws_biker1_ranged1_saratoga_ma", "Character.lch_tyger_claws_biker2_ranged2_copperhead_ma", "Character.lch_tyger_claws_biker1_ranged1_saratoga_wa", "Character.lch_tyger_claws_biker2_ranged2_copperhead_wa", "Character.lch_tyger_claws_gangster1_ranged1_copperhead_ma", "Character.lch_tyger_claws_gangster1_ranged1_copperhead_wa", "Character.lch_tyger_claws_gangster1_ranged1_nue_ma", "Character.lch_tyger_claws_gangster1_ranged1_nue_wa", "Character.lch_tyger_claws_gangster2_ranged2_copperhead_ma", "Character.lch_tyger_claws_gangster2_ranged2_copperhead_wa", "Character.lch_tyger_claws_gangster2_ranged2_shingen_ma", "Character.lch_tyger_claws_gangster2_ranged2_shingen_wa", "Character.lch_tyger_claws_gangster2_ranged2_sidewinder_ma", "Character.lch_tyger_claws_gangster2_ranged2_sidewinder_wa", "Character.sts_wat_lch_05_enemy_smg", "Character.sts_wat_lch_03_tyger_claw_handgun_basement", "Character.sts_wat_lch_01_tygerclaw_smg", "Character.sts_wat_lch_01_tygerclaw_rifle", "Character.sts_wat_lch_03_tyger_claws_gangster2_ranged2_copperhead_ma", "Character.sts_wat_lch_03_tyger_claws_gangster2_ranged2_sidewinder_ma",
	
	--Kabuki
	"Character.kab_tyger_claws_biker1_ranged1_nue_ma", "Character.kab_tyger_claws_biker1_ranged1_nue_wa", "Character.kab_tyger_claws_biker1_ranged1_saratoga_ma", "Character.kab_tyger_claws_biker1_ranged1_saratoga_wa", "Character.kab_tyger_claws_biker2_ranged2_copperhead_ma", "Character.kab_tyger_claws_biker2_ranged2_copperhead_wa", "Character.kab_tyger_claws_biker2_ranged2_shingen_ma", "Character.kab_tyger_claws_biker2_ranged2_shingen_wa", "Character.kab_tyger_claws_gangster1_ranged1_copperhead_ma", "Character.kab_tyger_claws_gangster1_ranged1_copperhead_wa", "Character.kab_tyger_claws_gangster1_ranged1_nue_ma", "Character.kab_tyger_claws_gangster1_ranged1_nue_wa", "Character.kab_tyger_claws_gangster2_ranged2_copperhead_ma", "Character.kab_tyger_claws_gangster2_ranged2_copperhead_wa", "Character.kab_tyger_claws_gangster2_ranged2_shingen_ma", "Character.kab_tyger_claws_gangster2_ranged2_shingen_wa", "Character.kab_tyger_claws_gangster2_ranged2_sidewinder_ma", "Character.kab_tyger_claws_gangster2_ranged2_sidewinder_wa", "Character.sts_wat_kab_08_tyger_claws_smg", 
	
	--Northside
	"Character.nid_05_maelstrom_server_room_wa", "Character.nid_05_maelstrom_rifle_man", "Character.nid_101_maelstrom_handgun", "Character.nid_maelstrom_fast_franged2_pulsar_ma_rare", "Character.nid_maelstrom_grunt1_ranged1_copperhead_ma", "Character.nid_maelstrom_grunt1_ranged1_copperhead_wa", "Character.nid_maelstrom_grunt1_ranged1_lexington_ma", "Character.nid_maelstrom_grunt1_ranged1_lexington_wa", "Character.nid_maelstrom_grunt2_ranged2_ajax_ma", "Character.nid_maelstrom_grunt2_ranged2_ajax_wa", "Character.nid_maelstrom_grunt2_ranged2_copperhead_ma", "Character.nid_maelstrom_grunt2_ranged2_copperhead_wa", "Character.nid_maelstrom_techie_grenadier2_lexington_ma",
	
	--Arasaka Waterfront
	"Character.waterfront_arasaka_android_android2_masamune_ma", "Character.waterfront_arasaka_ranger1_ranged2_shingen_ma",
	
	--Japantown
	"Character.jpn_02_ground_rifle", "Character.jpn_03_tyger_guard_handgun", "Character.jpn_03_tyger_guard_rifle", "Character.jpn_03_tyger_guard_wa", "Character.jpn_101_tyger_handgun", "Character.jpn_101_tyger_rifle", "Character.jpn_tyger_claws_biker1_ranged1_nue_ma", "Character.jpn_tyger_claws_biker1_ranged1_saratoga_ma", "Character.jpn_tyger_claws_biker1_ranged1_nue_wa", "Character.jpn_tyger_claws_biker2_ranged2_copperhead_ma", "Character.jpn_tyger_claws_biker2_ranged2_copperhead_wa", "Character.jpn_tyger_claws_biker2_ranged2_shingen_ma", "Character.jpn_tyger_claws_gangster1_ranged1_copperhead_ma", "Character.jpn_tyger_claws_gangster1_ranged1_copperhead_wa", "Character.jpn_tyger_claws_gangster1_ranged1_nue_ma", "Character.jpn_tyger_claws_gangster1_ranged1_nue_wa", "Character.jpn_tyger_claws_gangster2_ranged2_copperhead_ma", "Character.jpn_tyger_claws_gangster2_ranged2_copperhead_wa", "Character.jpn_tyger_claws_gangster2_ranged2_shingen_ma", "Character.jpn_tyger_claws_gangster2_ranged2_shingen_wa", "Character.jpn_tyger_claws_gangster2_ranged2_sidewinder_ma", "Character.jpn_tyger_claws_gangster2_ranged2_sidewinder_wa", "Character.sts_wbr_jpn_01_tygerclaw_handgun", "Character.sts_wbr_jpn_01_tygerclaw_rifle", "Character.sts_wbr_jpn_05_tygerclaw_handgun", "Character.sts_wbr_jpn_12_tyger_claws_gangster1_ranged1_nue_ma", "Character.sts_wbr_jpn_12_tyger_claws_gangster2_ranged2_copperhead_ma", "Character.sts_wbr_jpn_12_tyger_claws_gangster2_ranged2_copperhead_wa", "Character.sts_wbr_jpn_12_tyger_claws_gangster1_ranged1_nue_wa", "Character.sts_wbr_jpn_12_tyger_claws_gangster2_ranged2_shingen_ma", "Character.sts_wbr_jpn_12_tyger_claws_gangster2_ranged2_shingen_wa", 
	
	--Charter Hill
	"Character.hil_tyger_claws_biker1_ranged1_nue_ma", "Character.hil_tyger_claws_biker2_ranged2_copperhead_ma", "Character.hil_tyger_claws_gangster1_ranged1_copperhead_wa", "Character.hil_tyger_claws_gangster1_ranged1_nue_ma", "Character.hil_tyger_claws_gangster1_ranged1_nue_wa", "Character.hil_tyger_claws_gangster2_ranged2_shingen_ma", "Character.hil_tyger_claws_grunt_medium_range_m_medium", 
	
	--North Oak
	"Character.nok_arasaka_guard2_ranged1_kenshin_ma", "Character.nok_tyger_claws_gangster1_ranged1_copperhead_ma", "Character.nok_tyger_claws_gangster1_ranged1_nue_ma", "Character.nok_tyger_claws_gangster1_ranged1_nue_wa", "Character.nok_tyger_claws_gangster1_ranged1_copperhead_wa", "Character.nok_tyger_claws_gangster2_ranged2_copperhead_ma", "Character.nok_tyger_claws_gangster2_ranged2_copperhead_wa", "Character.nok_tyger_claws_gangster2_ranged2_sidewinder_wa",
	
	--Corpo Plaza
	"Character.cpz_arasaka_guard2_ranged1_kenshin_ma", "Character.cpz_arasaka_cyborg_grenadier3_yukimura_ma_elite", "Character.cpz_arasaka_bodyguard_ranged3_masamune_mb_rare", "Character.cpz_arasaka_bodyguard_ranged3_kenshin_mb_rare", "Character.cpz_arasaka_guard2_ranged1_shingen_ma", "Character.cpz_arasaka_guard2_ranged1_yukimura_ma", "Character.cpz_kangtao_ranger1_ranged2_dian_ma", "Character.cpz_militech_fast_elite_medium_range_m_medium", "Character.cpz_militech_ranger1_ranged1_saratoga_ma", "Character.cpz_militech_ranger2_ranged2_ajax_ma", "Character.cpz_security_guard1_ranged1_nue_ma", "Character.cpz_security_guard1_ranged1_saratoga_ma", "Character.cpz_security_security2_ranged2_ajax_ma", "Character.cpz_security_security2_ranged2_saratoga_ma", "Character.sts_cct_cpz_01_enemy_security_ajax", "Character.sts_cct_cpz_01_enemy_security_officer",
	
	--Downtown
	"Character.dtn_arasaka_guard2_ranged1_kenshin_ma", "Character.dtn_arasaka_guard2_ranged1_shingen_ma", "Character.dtn_militech_ranger1_ranged1_saratoga_ma", "Character.dtn_militech_ranger2_ranged2_ajax_ma", "Character.dtn_militech_tech_franged2_omaha_ma_rare", "Character.sts_cct_dtn_05_enemy_security_smg", "Character.sts_cct_dtn_05_enemy_security_officer",
	
	--Wellsprings
	"Character.spr_03_valentinos_ranged2_ajax_ma", "Character.spr_03_valentinos_ranged2_overture_ma", "Character.spr_valentinos_grunt1_ranged1_nova_ma", "Character.spr_valentinos_grunt1_ranged1_nova_wa", "Character.spr_valentinos_grunt1_ranged1_nue_ma", "Character.spr_valentinos_grunt1_ranged1_nue_wa", "Character.spr_valentinos_grunt2_ranged2_ajax_ma", "Character.spr_valentinos_grunt2_ranged2_ajax_wa", "Character.spr_valentinos_grunt2_ranged2_nue_ma", "Character.spr_valentinos_grunt2_ranged2_nue_wa", "Character.spr_valentinos_grunt2_ranged2_overture_ma", "Character.spr_valentinos_grunt2_ranged2_overture_wa", "Character.sts_hey_spr_01_valentino_ranged_female", "Character.sts_hey_spr_01_valentino_ranged_male", "Character.sts_hey_spr_01_valentino_rifle_wa",
	
	--Glen
	"Character.gle_valentinos_grunt1_ranged1_nova_ma", "Character.gle_valentinos_grunt1_ranged1_nova_wa", "Character.gle_valentinos_grunt1_ranged1_nue_ma", "Character.gle_valentinos_grunt1_ranged1_nue_wa", "Character.gle_valentinos_grunt2_ranged2_ajax_ma", "Character.gle_valentinos_grunt2_ranged2_ajax_wa", "Character.gle_valentinos_grunt2_ranged2_nue_ma", "Character.gle_valentinos_grunt2_ranged2_nue_wa", "Character.gle_valentinos_grunt2_ranged2_overture_ma", "Character.gle_valentinos_grunt2_ranged2_overture_wa", "Character.gle_04_valentinos_fast_rifleman_wa",
	
	--Vista Del Rey
	"Character.rey_valentinos_grunt1_ranged1_nova_ma", "Character.rey_valentinos_grunt1_ranged1_nova_wa", "Character.rey_valentinos_grunt1_ranged1_nue_ma", "Character.rey_valentinos_grunt1_ranged1_nue_wa", "Character.rey_valentinos_grunt2_ranged2_ajax_ma", "Character.rey_valentinos_grunt2_ranged2_ajax_wa", "Character.rey_valentinos_grunt2_ranged2_nue_ma", "Character.rey_valentinos_grunt2_ranged2_nue_wa", "Character.rey_valentinos_grunt2_ranged2_overture_ma", "Character.rey_valentinos_grunt2_ranged2_overture_wa", "Character.sts_hey_rey_01_valentions_apartment_range_wa", "Character.sts_hey_rey_01_valentions_apartment_rifleman", "Character.sts_hey_rey_02_valentinos_grunt1_ranged1_nue_ma", "Character.sts_hey_rey_02_valentinos_grunt1_ranged1_nue_wa", "Character.sts_hey_rey_02_valentinos_grunt2_ranged2_ajax_ma", "Character.sts_hey_rey_06_enemy_rifle", "Character.sts_hey_rey_06_enemy_gun_wa", "Character.sts_hey_rey_06_enemy_ajax", "Character.sts_hey_rey_08_valentions_rifle",
	
	
	--[[				Changed Pacifica to have scavs back up because there aren't any missions where you attack open world voodoo boys
	--Coast View
	"Character.cvi_voodooboys_grunt1_ranged2_saratoga_ma", "Character.cvi_voodooboys_grunt1_ranged2_saratoga_wa", "Character.cvi_voodooboys_grunt1_ranged2_sidewinder_wa",
	
	--West Wind Estate
	"Character.wwd_voodooboys_grunt1_ranged2_saratoga_ma", "Character.wwd_voodooboys_grunt1_ranged2_saratoga_wa", "Character.wwd_voodooboys_grunt1_ranged2_sidewinder_ma",
	]]--
	
	--Coast View
	"Character.cvi_scavenger_grunt1_ranged1_nova_ma", "Character.cvi_scavenger_grunt1_ranged1_nova_wa", "Character.cvi_scavenger_grunt1_ranged1_pulsar_ma", "Character.cvi_scavenger_grunt1_ranged1_pulsar_wa", "Character.cvi_scavenger_grunt1_ranged1_slaughtomatic_ma", "Character.cvi_scavenger_grunt1_ranged1_slaughtomatic_wa", "Character.cvi_scavenger_grunt2_ranged2_copperhead_ma", "Character.cvi_scavenger_grunt2_ranged2_copperhead_wa", "Character.cvi_scavenger_grunt2_ranged2_pulsar_ma", "Character.cvi_scavenger_grunt2_ranged2_pulsar_wa",
	--West Wind Estate
	"Character.wwd_scavenger_grunt1_ranged1_nova_ma", "Character.wwd_scavenger_grunt1_ranged1_nova_wa", "Character.wwd_scavenger_grunt1_ranged1_pulsar_ma", "Character.wwd_scavenger_grunt1_ranged1_pulsar_wa", "Character.wwd_scavenger_grunt1_ranged1_slaughtomatic_ma", "Character.wwd_scavenger_grunt1_ranged1_slaughtomatic_wa", "Character.wwd_scavenger_grunt2_ranged2_copperhead_ma", "Character.wwd_scavenger_grunt2_ranged2_copperhead_wa", "Character.wwd_scavenger_grunt2_ranged2_pulsar_ma", "Character.wwd_scavenger_grunt2_ranged2_pulsar_wa",
	
	--Badlands South
	"Character.bls_se_wraiths_grunt1_ranged1_nova_ma", "Character.bls_se_wraiths_grunt1_ranged1_nova_wa", "Character.bls_se_wraiths_grunt1_ranged1_pulsar_ma", "Character.bls_se_wraiths_grunt1_ranged1_pulsar_wa", "Character.bls_se_wraiths_grunt2_ranged2_copperhead_ma", "Character.bls_se_wraiths_grunt2_ranged2_copperhead_wa", "Character.bls_se_wraiths_grunt2_ranged2_pulsar_ma", "Character.bls_se_wraiths_grunt2_ranged2_pulsar_wa", 
	
	--Badlands East
	"Character.sts_bls_ina_08_wraith_med_med_m", "Character.sts_bls_ina_08_wraith_med_med_w", "Character.sts_bls_ina_08_wraith_nova_wa",
	
	--NCPD
	"Character.cpz_ncpd_android_android2_ajax_ma", "Character.cpz_ncpd_constable_ranged1_lexington_ma", "Character.cpz_ncpd_inspector_ranged1_lexington_ma", "Character.cpz_ncpd_investigator_officer_omaha_ma", "Character.cpz_ncpd_police_ranged2_copperhead_ma", "Character.cpz_ncpd_police_ranged2_lexington_ma", "Character.cpz_ncpd_police_ranged2_saratoga_ma", "Character.dtn_ncpd_constable_ranged1_lexington_ma", "Character.dtn_ncpd_inspector_ranged1_lexington_ma", "Character.dtn_ncpd_investigator_officer_omaha_ma", "Character.dtn_ncpd_police_ranged2_copperhead_ma", "Character.dtn_ncpd_police_ranged2_lexington_ma", "Character.dtn_ncpd_police_ranged2_saratoga_ma", "Character.nok_ncpd_android_android2_ajax_ma", "Character.nok_ncpd_constable_ranged1_lexington_ma", "Character.nok_ncpd_inspector_ranged1_lexington_ma", "Character.nok_ncpd_investigator_officer_omaha_ma", "Character.nok_ncpd_police_ranged2_copperhead_ma", "Character.nok_ncpd_police_ranged2_lexington_ma", "Character.nok_ncpd_police_ranged2_saratoga_ma"
	} 
	for i,v in ipairs(Character_List) do
		addCallReinforcements(v)
		
		--The tag means they'll attack V when in their district
		addAbility(v..".tags", "TriggerPrevention")
	end
	
	


end
function addNullifyCallReinforcements(statusEffect)
	TDB_CR = ToTweakDBID{ hash = 0xCCC0B8D1, length = 32 }
	packages = TweakDB:GetFlat(statusEffect..".packages")
	if has_value(packages, TDB_CR) then
	
	else
		table.insert(packages, TDB_CR)
		TweakDB:SetFlat(statusEffect..".packages", packages)
	end
end
function addCallReinforcements(character)
	abilities = TweakDB:GetFlat(character..".abilities")
	abilityID = ToTweakDBID{ hash = 0xC9F1AB7C, length = 29 }
	--TweakDB:SetFlat(character..".sensePreset", "Senses.Absolute")
	if has_value(abilities, abilityID) then
	
	else
		table.insert(abilities, abilityID)
		TweakDB:SetFlat(character..".abilities", abilities)
	end
end

function addAbility(list, ability)
	TweakDB:SetFlat("RTDB.ActionTargetPrereq.target", ability)
	abilityhash=TweakDB:GetFlat("RTDB.ActionTargetPrereq.target")
	templist = TweakDB:GetFlat(list)
	if has_value(templist, abilityhash) then
	
	else

		table.insert(templist, ability)
		TweakDB:SetFlat(list, templist)
	end
end
function has_value (tab, val)
    for index, value in ipairs(tab) do
        if value == val then
		
            return true
        end
    end

    return false
end
function createConstantStatModifier(recordName, modifierType, statType, value)
	TweakDB:CreateRecord(recordName, "gamedataConstantStatModifier_Record")
	TweakDB:SetFlat(recordName..".modifierType", modifierType)
	TweakDB:SetFlat(recordName..".statType", statType)
	TweakDB:SetFlat(recordName..".value", value)
end

return VehicleCombat:new()
